<?php

namespace App\Http\Controllers\Api\Profile;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\Storage;

use App\Models\User;
use App\Models\Schedule;
use App\Models\Locations;
use App\Models\CompanyDepartment;
use App\Models\Checklist;

use App\Models\ChecklistSection;
use App\Models\ChecklistQuestion;
use App\Models\AuditReport;
use App\Models\AuditQuestionReport;

class ActionsController extends Controller
{
    public function list(Request $request){
        $user = auth()->user();

        $status_action = $request->input('status');

        $from = $request->input('from');
        $to = $request->input('to');
        $signal_date = $request->input('signal_date');
        
        if($status_action == null || $status_action == ''){
            $schedule_action = [];
        }elseif($status_action == 0){
            // $schedule_action = Schedule::where('auditor_id', $user->id)->get();
            if(($from != null && $to != null) || ($from != '' && $to != '')){
                $schedule_action = Schedule::where('auditor_id', $user->id)->whereBetween('schedule_on', [date('Y-m-d H:i:s' , strtotime($from)), date('Y-m-d H:i:s' , strtotime($to))])->where('action_status','!=',null)->orderBy('created_at', 'desc')->get();
            }elseif($signal_date != null || $signal_date != ''){
                $schedule_action = Schedule::where('auditor_id', $user->id)->where('schedule_on', date('Y-m-d H:i:s' , strtotime($signal_date)))->where('action_status','!=',null)->orderBy('created_at', 'desc')->get();
            }else{
                $schedule_action = Schedule::where('auditor_id', $user->id)->where('action_status','!=',null)->orderBy('created_at', 'desc')->get();
            }
        }else{
            // $schedule_action = Schedule::where('auditor_id', $user->id)->where('action_status', $status_action)->get();
            if(($from != null && $to != null) || ($from != '' && $to != '')){
                $schedule_action = Schedule::where('auditor_id', $user->id)->where('action_status', $status_action)->where('action_status','!=',null)->whereBetween('schedule_on', [date('Y-m-d H:i:s' , strtotime($from)), date('Y-m-d H:i:s' , strtotime($to))])->orderBy('created_at', 'desc')->get();
            }elseif($signal_date != null || $signal_date != ''){
                $schedule_action = Schedule::where('auditor_id', $user->id)->where('action_status', $status_action)->where('action_status','!=',null)->where('schedule_on', date('Y-m-d H:i:s' , strtotime($signal_date)))->orderBy('created_at', 'desc')->get();
            }else{
                $schedule_action = Schedule::where('auditor_id', $user->id)->where('action_status', $status_action)->where('action_status','!=',null)->orderBy('created_at', 'desc')->get();
            }
        }

        if(empty(count($schedule_action))){
            $actions_array = [];
        }else{
            $actions_array = [];
            for($i = 0; $i < count($schedule_action); $i++){
                $user_schedule = User::where('id', $schedule_action[$i]['auditor_id'])->get()->first();
                $user_location = Locations::where('id', $schedule_action[$i]['location_id'])->get()->first();
                $user_department = CompanyDepartment::where('id', $schedule_action[$i]['company_id'])->get()->first();
                $checklist = Checklist::where('id', $schedule_action[$i]['checklist_id'])->get()->first();
                $reschedule_status = $schedule_action[$i]['reschedule_status'];
                $audit_report = AuditReport::where('schedule_id', $schedule_action[$i]['id'])->get()->first();
                // dd($audit_report['audit_id']);
                if(empty($reschedule_status) || $reschedule_status = 0){
                    $schedule_on = $schedule_action[$i]['schedule_on']->format('dS M, l');
                    $schedule_time = $schedule_action[$i]['start_time']->format('h:i A').' To '.$schedule_action[$i]['end_time']->format('h:i A');
                }else{
                    $schedule_on = $schedule_action[$i]['reschedule_on']->format('dS M, l');
                    $schedule_time = $schedule_action[$i]['re_start_time']->format('h:i A').' To '.$schedule_action[$i]['re_end_time']->format('h:i A');
                }
                if(!empty($audit_report['audit_id'])){
                    $audit_id = $audit_report['audit_id'];
                }else{
                    $audit_id = null;
                }
                $status = [
                    '1' => 'Open',
                    '2' => 'In Progress',
                    '3' => 'Overdue',
                    '4' => 'Completed'
                ];
                $reschedule = [
                    null => 'No',
                    '' => 'No',
                    '0' => 'No',
                    '1' => 'Yes'
                ];
                $action_status = [
                    '' => null,
                    '0' => null,
                    '1' => 'In Review',
                    '2' => 'Completed',
                    '3' => 'Rejected'
                ];
                $action_message = [
                    '' => null,
                    '0' => null,
                    '1' => 'Under Inspection',
                    '2' => 'Approved',
                    '3' => 'Standards Disparity'
                ];

                $actions_array[] = [
                    'id' => $schedule_action[$i]['id'],
                    'audit_id' => $audit_id,
                    'schedule_on' => $schedule_on,
                    'status' => $status[$schedule_action[$i]['status']],
                    'reschedule_status' => $reschedule[$schedule_action[$i]['reschedule_status']],
                    'schedule_id' => $schedule_action[$i]['schedule_id'],
                    'checklist_id' => $schedule_action[$i]['checklist_id'],
                    'checklist_name' => $checklist['name'],
                    'schedule_time' => $schedule_time,
                    'company_id' => $user_department['user_id'],
                    'company_avatar' => $user_department['logos'],
                    'company_name' => $user_department['name'],
                    'location' => $user_location['name'],
                    'auditor_id' => $user_schedule['user_id'],
                    'auditor_avatar' => $user_schedule['avatar_img'],
                    'auditor_name' => ucwords($user_schedule['first_name']).' '.ucwords($user_schedule['last_name']),
                    'action_status' => $action_status[$schedule_action[$i]['action_status']],
                    'action_message' => $action_message[$schedule_action[$i]['action_message']]
                ];
            }
        }

        if($user){
            if(sizeof($actions_array)){
                $actions = $actions_array;
                return response()->json([
                    'status' => true,
                    'message' => 'Action Panel',
                    'data' => $actions
                ],200);
            }else{
                $actions = null;
                return response()->json([
                    'status' => false,
                    'message' => 'No Data Found.',
                    'data' => $actions
                ],200);
            }
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],200);
        }
    }

    public function generatereport(Request $request){
        $user = auth()->user();
        $base_url = env('APP_URL');
        $report_id = $request->input('report_id');

        $printreport = AuditReport::where('audit_id', $report_id)->get();
        
        $printlist = [];
        for($i = 0; $i < count($printreport); $i++){
            $auditor = User::where('id', $printreport[$i]['created_by'])->get()->first();
            $schedule = Schedule::where('id', $printreport[$i]['schedule_id'])->get()->first();
            $company = CompanyDepartment::where('id', $schedule['company_id'])->get()->first();
            $total_question = ChecklistQuestion::where('checklist_id', $printreport[$i]['checklist_id'])->get()->count();
            $total_ques_answered = AuditQuestionReport::where('schedule_id', $printreport[$i]['schedule_id'])->where('checklist_id', $printreport[$i]['checklist_id'])->get()->count();

            $user_department = CompanyDepartment::where('id', $schedule['company_id'])->get()->first();
            $checklist_section = ChecklistSection::where('checklist_id', $printreport[$i]['checklist_id'])->get();
            $checklist_question_total = ChecklistQuestion::where('checklist_id', $printreport[$i]['checklist_id'])->get();
            $checklist_question_answer = AuditQuestionReport::where('schedule_id', $printreport[$i]['schedule_id'])->where('checklist_id', $printreport[$i]['checklist_id'])->get();

            if($total_question != 0){
                $percent_total = $total_ques_answered / $total_question * 100;
                $percent = round($percent_total, 0);
            }else{
                $percent = 0;
            }

            for($ia = 0; $ia < count($checklist_section); $ia++){
                
                $checklist_question = ChecklistQuestion::where('section_id', '=', $checklist_section[$ia]['id'])->where('checklist_id','=', $printreport[$i]['checklist_id'])->get();
                $checklist_answer = AuditQuestionReport::where('section_id', '=', $checklist_section[$ia]['id'])->where('schedule_id', $printreport[$i]['schedule_id'])->where('checklist_id', $printreport[$i]['checklist_id'])->get();

                if(count($checklist_question) == 0){
                    $checklist_questions = null;
                }else{
                    $checklist_questions = [];
                    for($xy = 0; $xy < count($checklist_question); $xy++){
                        $questionanswer = AuditQuestionReport::where('questions_id',$checklist_question[$xy]['id'])->where('schedule_id', $printreport[$i]['schedule_id'])->where('checklist_id', $printreport[$i]['checklist_id'])->get();
						
                        if(count($questionanswer) != 1){
                            $questionanswers = null;
                            $questions_images = null;
                            $questions_comments = null;
                        }else{
                            $questionanswers = $questionanswer[0]['questions_answer'];
                            $questions_images = $questionanswer[0]['questions_image'];
                            $questions_comments = $questionanswer[0]['questions_comment'];
                        }

                        $checklist_questions[] = [
                            'id' => $checklist_question[$xy]['id'],
                            'questions_id' => $checklist_question[$xy]['questions_id'],
                            'title' => $checklist_question[$xy]['title'],
                            'questions_answer' => $questionanswers,
                            'questions_image' => $questions_images,
                            'questions_comment' => $questions_comments,
                            'created_at' => $checklist_question[$xy]['created_at'],
                            'updated_at' => $checklist_question[$xy]['updated_at']
                        ];
                    }
                }

                $section[] =[
                    'section_id' => $checklist_section[$ia]['section_id'],
                    'section_name' => $checklist_section[$ia]['name'],
                    'section_total_question' => $checklist_question->count(),
                    'section_total_answer' => $checklist_answer->count(),
                    'section_question' => $checklist_questions
                ];
            }

            $printlist[] = [
                'id' => $printreport[$i]['id'],
                'report_id' => $printreport[$i]['audit_id'],
                'report_name' => $printreport[$i]['checklist_name'],
                'company_id' => $company['user_id'],
                'company_name' => $company['name'],
                'location' => $printreport[$i]['location_name'],
                'date' => $printreport[$i]['audit_date'],
                'submitted_by_id' => $auditor['user_id'],
                'submitted_by_name' => $auditor['first_name'].' '.$auditor['last_name'],

                'total_section' => $checklist_section->count(),
                'total_question' => $checklist_question_total->count(),
                'total_answer' => $checklist_question_answer->count(),
                'section' => $section,
                
                'signature_image' => asset('storage/app/signature/'.$schedule['schedule_id']).'/'.$printreport[$i]['signature_image'],
                'question_image' => asset('storage/app/question/'.$schedule['schedule_id']).'/',
                'status' => $printreport[$i]['status'],
                'score' => $percent
            ];
        }

        $data = [
            'id' => $printlist[0]['id'],
            'report_id' => $printlist[0]['report_id'],
            'company_id' => $printlist[0]['company_id'],
            'company_name' => $printlist[0]['company_name'],
            
            'location' => $printlist[0]['location'],
            'date' => $printlist[0]['date'],
            'submitted_by_id' => $printlist[0]['submitted_by_id'],
            'submitted_by_name' => $printlist[0]['submitted_by_name'],

            'total_section' => $printlist[0]['total_section'],
            'total_question' => $printlist[0]['total_question'],
            'total_answer' => $printlist[0]['total_answer'],
            'section' => $printlist[0]['section'],
                
            'signature_image' => $printlist[0]['signature_image'],
            'question_image' => $printlist[0]['question_image'],
            'status' => $printlist[0]['status'],
            'score' => $printlist[0]['score']
        ];
        $pdf = Pdf::loadView('pdf.report', compact('data'));
        $pdf->setOption('defaultFont', 'Montserrat');

        $pdfDirectory = base_path('public/report/pdf/');
                
        if (!file_exists($pdfDirectory)) {
            mkdir($pdfDirectory, 0777, true);
        }

        $randomNumber = rand(1000, 9999);
        $fileName = $printlist[0]['report_id']  . '.pdf';
        
        $pdfPath = $pdfDirectory . $fileName;
        $pdf->save($pdfPath);

        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

        if($printreport){
            return response()->json([
                'status' => true,
                    'message' => 'The report has been generated successfully. You can download or view the PDF.',
                    'data' => [
                        'report_id' => $printlist[0]['report_id'],
                        'report_url' => $base_url.'/report/pdf/'.$printlist[0]['report_id'].'.pdf'
                    ]
            ]);
            
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your report is not generated.',
                'data' => null
            ],401);
        }
    }
    // public function generatereport(Request $request){
    //     $user = auth()->user();
    //     $base_url = env('APP_URL');
    //     $report_id = $request->input('report_id');

    //     $printreport = AuditReport::with(['schedule', 'schedule.company', 'createdBy', 'checklist.sections.questions.auditReport'])
    //         ->where('audit_id', $report_id)
    //         ->first();

    //     if (!$printreport) {
    //         return response()->json(['status' => false, 'message' => 'No report found'], 404);
    //     }

    //     $schedule = $printreport->schedule ?? null;
    //     $auditor = $printreport->createdBy ?? null;
    //     $checklist = $printreport->checklist ?? null;

    //     if (!$schedule || !$auditor || !$checklist) {
    //         return response()->json(['status' => false, 'message' => 'Incomplete report data'], 422);
    //     }

    //     $company = $schedule->company ?? null;
    //     $total_question = $checklist->questions->count();
    //     $total_ques_answered = $printreport->schedule->auditReports->where('checklist_id', $checklist->id)->count();
    //     $percent = $total_question > 0 ? round(($total_ques_answered / $total_question) * 100, 0) : 0;

    //     $sections = [];
    //     foreach ($checklist->sections as $section) {
    //         $section_questions = [];
    //         foreach ($section->questions as $question) {
    //             $answer = $question->auditReport->where('schedule_id', $schedule->id)->where('checklist_id', $checklist->id)->first();

    //             $section_questions[] = [
    //                 'id' => $question->id,
    //                 'questions_id' => $question->questions_id,
    //                 'title' => $question->title,
    //                 'questions_answer' => $answer->questions_answer ?? null,
    //                 'questions_image' => $answer->questions_image ?? null,
    //                 'questions_comment' => $answer->questions_comment ?? null,
    //                 'created_at' => $question->created_at,
    //                 'updated_at' => $question->updated_at
    //             ];
    //         }

    //         $sections[] = [
    //             'section_id' => $section->id,
    //             'section_name' => $section->name,
    //             'section_total_question' => count($section->questions),
    //             'section_total_answer' => count($section_questions),
    //             'section_question' => $section_questions
    //         ];
    //     }

    //     $data = [
    //         'id' => $printreport->id,
    //         'report_id' => $printreport->audit_id,
    //         'report_name' => $checklist->name,
    //         'company_id' => $company->user_id ?? null,
    //         'company_name' => $company->name ?? 'N/A',
    //         'location' => $printreport->location_name,
    //         'date' => $printreport->audit_date,
    //         'submitted_by_id' => $auditor->user_id,
    //         'submitted_by_name' => "{$auditor->first_name} {$auditor->last_name}",
    //         'total_section' => count($sections),
    //         'total_question' => $total_question,
    //         'total_answer' => $total_ques_answered,
    //         'section' => $sections,
    //         'signature_image' => asset("signature/{$schedule->id}/{$printreport->signature_image}"),
    //         'question_image' => asset("question/{$schedule->id}/"),
    //         'status' => $printreport->status,
    //         'score' => $percent
    //     ];

    //     // Generate PDF
    //     $pdf = Pdf::loadView('pdf.report', compact('data'))->setOption('defaultFont', 'Montserrat');

    //     // Store PDF in public/report_pdf/
    //     $pdfDirectory = public_path('report_pdf/');
    //     if (!is_dir($pdfDirectory) && !mkdir($pdfDirectory, 0777, true) && !is_dir($pdfDirectory)) {
    //         return response()->json(['status' => false, 'message' => 'Failed to create report directory'], 500);
    //     }

    //     $fileName = $data['report_id'] . '.pdf';
    //     $pdfPath = public_path("report_pdf/{$fileName}");
    //     file_put_contents($pdfPath, $pdf->output());

    //     // Generate Public URL
    //     $reportUrl = asset("report_pdf/{$fileName}");

    //     return response()->json([
    //         'status' => true,
    //         'message' => 'Report generated successfully.',
    //         'data' => [
    //             'report_id' => $data['report_id'],
    //             'report_url' => $reportUrl
    //         ]
    //     ]);
    // }
    public function scores(Request $request){
        $report_id = $request->input('report_id');
        return response()->json([
            'status' => true,
            'message' => 'Score needs to improve.',
            'data' => [
                "report_id" => $report_id,
                "percentage_score"=> "30",
                "percentage_out_of"=> "100",
                "scored_point"=> "69",
                "scored_out_of"=> "220",
                "risk"=>"Low"
            ]
        ],200);
    }
    
}
