<?php

namespace App\Http\Controllers\Api\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\RegistrationRequest;
use App\Http\Requests\LoginRequest;
use App\Http\Requests\ForgetRequest;
use App\Http\Requests\ResetRequest;
use App\Http\Requests\ChangeRequest;
use App\Http\Requests\Dashboard\ResetWebRequest;
use App\Models\User;
use App\Models\Invoice;
use App\Models\PasswordResetTokens;
use App\Models\PasswordReset;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;
// use Illuminate\Support\Str;
use Mail;
use App\Models\Plans;

class AuthController extends Controller
{
    public function login(LoginRequest $request){
        // auth()->factory()->setTTL(1);
        $token = auth()->attempt($request->validated());
        if($token){
            $user = auth()->user();
            if($user->deleted_at != null){
                return response()->json([
                    'status' => false,
                    'message' => 'Your account has been deactivated.',
                    'data' => null
                ],401);
            }
            if($user->plan_day_remain == '0' || $user->plan_day_remain == null){
                return response()->json([
                    'status' => false,
                    'message' => 'Your account plan has not been renewed.',
                    'data' => null
                ], 401);
            }
            if($user->role == '1' || $user->role == '2'){
                return response()->json([
                    'status' => false,
                    'message' => 'Your account doesn\'t have a right access app',
                    'data' => null
                ], 401);
            }
            return $this->responseWithToken($token, auth()->user());
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account does not exist.',
                'data' => null
            ],401);
        }
    }
    public function loginweb(LoginRequest $request){
        // auth()->factory()->setTTL(1);
        $token = auth()->attempt($request->validated());
        if($token){
            $user = auth()->user();
            if($user->deleted_at != null){
                return response()->json([
                    'status' => false,
                    'message' => 'Your account has been deactivated.',
                    'data' => null
                ],401);
            }
            // if($user->plan_day_remain == '0' || $user->plan_day_remain == null){
            //     return response()->json([
            //         'status' => false,
            //         'message' => 'Your account plan has not been renewed.',
            //         'data' => null
            //     ], 401);
            // }
            if($user->role == '3'){
                return response()->json([
                    'status' => false,
                    'message' => 'Your account doesn\'t have a right access Web Panel',
                    'data' => null
                ], 401);
            }
            return $this->responseWithToken($token, auth()->user());
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account does not exist.',
                'data' => null
            ],401);
        }
    }
    public function logout()
    {
        $logout = auth()->logout();
        return response()->json([
            'status' => true,
            'message' => 'Your account has successfully logged out.'
        ],200);
    }
    public function register(RegistrationRequest $request){
        $user = User::create($request->validated());

        $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $pin = rand(10, 50)
        . rand(10, 50)
        . $characters[rand(0, strlen($characters) - 1)];
        $string = str_shuffle($pin);
        
        // $digits = 3;
        // $invoiceNo = rand(pow(10, $digits-1), pow(10, $digits)-1);
        
        $lastInvoice = Invoice::orderBy('id', 'desc')->first();
            
        // If there is no previous invoice, start with 'IN-01'
        if (!$lastInvoice) {
            $newInvoiceId = 'IN-001';
        } else {
            // Extract the number part from the last invoice_id and increment it
            $lastIdNumber = intval(str_replace('IN-', '', $lastInvoice->invoice_id));
            $newIdNumber = $lastIdNumber + 1;
            // Format the new ID with leading zeros if necessary (e.g., 'IN-01', 'IN-002')
            $newInvoiceId = 'IN-' . str_pad($newIdNumber, 2, '0', STR_PAD_LEFT);
        }
        $invoice_id = $newInvoiceId;
        
        $transaction_id = 'TFG'.$string;
        $sectionid = User::orderBy('id', 'desc')->get()->first();
        
        $plans = Plans::where('id' ,1)->get()->first();
        $end_date = now()->addDays($plans->days);
        
        $createInvoice = Invoice::create([
            'invoice_id' => $invoice_id,
            'transaction_id' =>$transaction_id,
            'bank_id' => 1,
            'company_id' => $sectionid['id'],
            'company_image' => ' ',
            'company_name' => $user['first_name'].' '.$user['last_name'],
            'company_number' => $user['mobile_no'],
            'plan_status' => 1,
            'plan_actived' => 1,
            'plan_issued_date' => now(),
            'plan_paided_status' => 1,
            'plan_amount' => 0,
            'billing_type' => 1,
            'billing_start_date' => now(),
            'billing_end_date' => $end_date,
            'status' => 1,
            'created_by' => $sectionid['id'],
            'created_at' => now()
        ]);

        $base_url = env('APP_URL');
        $data['url'] = $base_url;
        $data['email'] = $user['email'];
        $data['title'] = 'Welcome to Lensaudit';
        $data['username'] = $user['first_name'].' '.$user['last_name'];
        $data['body'] = 'Ready to empower your team! You"re almost there - you just need to complete your profile to get started';

        Mail::send('welcomemail',['data'=>$data],function($message) use ($data){
            $message->to($data['email'])->subject($data['title']);
        });
        
        if($user){
            $token = auth()->login($user);
            return $this->registerResponseWithToken($token, $user);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account is not registered.',
                'data' => null
            ],401);
        }
    }
    public function responseWithToken($token, $user){
        return response()->json([
            'status' => true,
            'message' => 'Your account has successfully logged in.',
            'data' => [
                'profile' => $user,
                'authorization' => [
                    'token' => $token,
                    'expires_at' => auth()->factory()->getTTL() * 60,
                    'type' => 'bearer'
                ]
            ],
            
        ],200);
    }
    public function registerResponseWithToken($token, $user){
        return response()->json([
            'status' => true,
            'message' => 'Your account has successfully registered.',
            'data' => [
                'profile' => $user,
                'authorization' => [
                    'token' => $token,
                    'expires_at' => auth()->factory()->getTTL() * 60,
                    'type' => 'bearer'
                ]
            ],
            
        ],200);
    }
    
    //Web
    public function forget(ForgetRequest $request){
        $email = $request->input('email');
        $user = User::where('email',$email)->first();
        if(!$user || !$user->email){
            return response()->json([
                'status' => false,
                'message' => 'Your account is not registered.',
                'data' => null
            ],404);
        }else{
            $token = Str::random(40);
            $base_url = env('APP_URL');
            $url = $base_url.'/reset-password?token='.$token;

            $data['url'] = $url;
            $data['email'] = $request->input('email');
            $data['title'] = 'Password Reset';
            $data['body'] = 'Please click on below link to reset your password';

            Mail::send('forgetpassword',['data'=>$data],function($message) use ($data){
                $message->to($data['email'])->subject($data['title']);
            });
            
            PasswordResetTokens::UpdateOrCreate(
                ['email' => $request->input('email')],
                [
                    'email' => $request->input('email'),
                    'token' => $token,
                    'created_at' => now(),
                ]
            );
            return response()->json([
                'status' => true,
                'message' => 'Mail has been sent to your registered Email ID.',
                'data' => null
            ],200);
        }
    }
    public function reset(ResetWebRequest $request){
        $token = $request->token;
        $reset = PasswordResetTokens::where('token',$token)->get()->first();
        
        if(empty($reset)){
            return response()->json([
                'status' => false,
                'message' => 'Your account is not registered.',
                'data' => null
            ],200);
        }else{
            $user = User::where('email',$reset->email)->get()->first();
            return response()->json([
                'status' => true,
                'message' => 'Verified',
                'data' => $user
            ],200);
        }
    }
    public function changepassword(ChangeRequest $request){
        $updatePassword = User::where('id',$request->input('id'))->update([
            'password' => Hash::make($request['password'])
        ]);
        if($updatePassword){
            $users = User::where('id',$request->input('id'))->get()->first();
            $deleteToken = PasswordResetTokens::where('email', $users->email)->delete();
            return response()->json([
                'status' => true,
                'message' => 'Your password updated successfully.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }

    //APP
    public function forgetApp(ForgetRequest $request){
        $email = $request->input('email');
        $user = User::where('email',$email)->first();
        if(!$user || !$user->email){
            return response()->json([
                'status' => false,
                'message' => 'Your account is not registered.',
                'data' => null
            ],404);
        }else{
            $digits = 6;
            $otpNo = rand(pow(10, $digits-1), pow(10, $digits)-1);
            $token = $otpNo;
            $base_url = env('APP_URL');

            $data['token'] = $token;
            $data['email'] = $request->input('email');
            $data['title'] = 'Password Reset';
            $data['body'] = 'Please enter below OTP Password';

            Mail::send('forgetpasswordm',['data'=>$data],function($message) use ($data){
                $message->to($data['email'])->subject($data['title']);
            });
            
            PasswordReset::UpdateOrCreate(
                ['email' => $request->input('email')],
                [
                    'email' => $request->input('email'),
                    'otp' => $token,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]
            );
            return response()->json([
                'status' => true,
                'message' => 'OTP has been sent to your registered Email ID.',
                'data' => null
            ],200);
        }
    }
    public function resetApp(ResetRequest $request){
        $otp = $request->input('otp');
        $reset = PasswordReset::where('otp',$otp)->first();

        if(empty($reset)){
            return response()->json([
                'status' => false,
                'message' => 'OTP don\'t not exist.',
                'data' => null
            ],200);
        }else{
            $user = User::where('email',$reset->email)->first();
            return response()->json([
                'status' => true,
                'message' => 'OTP Verified',
                'data' => $user
            ],200);
        }
    }
    public function changepasswordApp(ChangeRequest $request){
        $updatePassword = User::where('id',$request->input('id'))->update([
            'password' => Hash::make($request['password'])
        ]);
        if($updatePassword){
            $users = User::where('id',$request->input('id'))->get()->first();
            $deleteToken = PasswordResetTokens::where('email', $users->email)->delete();
            return response()->json([
                'status' => true,
                'message' => 'Your password updated successfully.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
    public function dayscount(Request $request){}
}
