<?php

namespace App\Customs\Services;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\ChecklistSection;

class SectionService
{
    public function createSection($data){
        $user = auth()->user();
        $digits = 3;
        $sectionNo = rand(pow(10, $digits-1), pow(10, $digits)-1);;
        $section_id = 'SI-'.$sectionNo;

        $createSection = ChecklistSection::create([
            'section_id' => $section_id,
            'name' => $data['name'],
            'checklist_id' => $data['checklist_id'],
            'company_id' => $user->id,
            'status' => $data['status'],
            'created_by' => $user->id,
            'updated_by' => 0,
            'deleted_by' => 0,
            'created_at' => now(),
            'updated_at' => now()
        ]);
        if($createSection){
            return response()->json([
                'status' => true,
                'message' => 'Checklist Section has been inserted.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
    
    public function updateSection($data){
        $user = auth()->user();
        $updateSection = ChecklistSection::where('id',$data['id'])->update([
            'name' => $data['name'],
            'checklist_id' => $data['checklist_id'],
            'status' => $data['status'],
            'updated_by' => $user->id,
            'updated_at' => now()
        ]);
        if($updateSection){
            return response()->json([
                'status' => true,
                'message' => 'Checklist Section has been updated.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
}