<?php

namespace App\Customs\Services;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Schedule;
use App\Models\ChecklistQuestion;
use App\Models\Checklist;

class SchedulewService
{
    public function createSchedule($data){
        $user = auth()->user();
        
        $checklistquestion = ChecklistQuestion::where('checklist_id', $data['checklist_id'])->get()->count();
        $checklist = Checklist::where('id', $data['checklist_id'])->get()->first();

        if($checklistquestion==0){
            return response()->json([
                'status' => false,
                'message' => 'No Questions.'
            ],401);
        }

        $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $pin = rand(10, 50)
        . rand(10, 50)
        . $characters[rand(0, strlen($characters) - 1)];
        $string = str_shuffle($pin);

        $user_id = 'SI-'.$string;

        $createSchedule = Schedule::create([
            'schedule_id' => $user_id,
            'checklist_id' => $data['checklist_id'],
            'category_id' => $checklist->category_id,
            'location_id' => $data['location_id'],
            'auditor_id' => $data['auditor_id'],
            'company_id' => $data['company_id'],
            'schedule_on' => $data['schedule_on'],
            'start_time' => $data['start_time'],
            'end_time' => $data['end_time'],
            'created_by' => $user->id,
            'created_at' => now(),
            'total_question' => $checklistquestion,
            'total_ques_answered' => 0,
            'status' => 1
        ]);
        if($createSchedule){
            return response()->json([
                'status' => true,
                'message' => 'Schedule has been inserted.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
    public function updateSchedule($data){
        $user = auth()->user();
        $updateSchedule = Schedule::where('id',$data['id'])->update([
            'status' => 3
        ]);
        if($updateSchedule){
            return response()->json([
                'status' => true,
                'message' => 'Schedule has been updated.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
}