<?php

namespace App\Customs\Services;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Schedule;

class ScheduleService
{
    public function updateReschedule($data){
        $user = auth()->user();
        $updateReschedule = Schedule::where('id',$data['id'])->update([
            'auditor_id' => $user->id,
            'reasons' => $data['reasons'],
            'other_message' => $data['other_message'],
            'reschedule_on' => date('Y-m-d H:i:s' , strtotime($data['reschedule_on'])),
            're_start_time' => date('H:i:s' , strtotime($data['re_start_time'])),
            're_end_time' => date('H:i:s' , strtotime($data['re_end_time'])),
            'updated_by' => $user->id,
            'updated_at' => now(),
            'reschedule_status' => 1,
            'status' => 1
        ]);
        if($updateReschedule){
            return response()->json([
                'status' => true,
                'message' => 'Audit has been rescheduled.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
}