<?php

namespace App\Customs\Services;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Checklist;
use App\Models\Results;

class ResultService{
    public function createResult($data){
        $user = auth()->user();
        $digits = 3;
        $resultsNo = rand(pow(10, $digits-1), pow(10, $digits)-1);;
        $result_id = 'R-'.$resultsNo;

        $checklist = Checklist::where('id', $data['checklist_id'])->get()->first();

        $createResults = Results::create([
            'result_id' => $result_id,
            'checklist_id' => $data['checklist_id'],
            'category_id' => $checklist->category_id,
            'name' => $data['name'],
            'symbols' => $data['symbols'],
            'percentage' => $data['percentage'],
            'color' => $data['color'],
            'status' => $data['status'],
            'created_by' => $user->id,
            'updated_by' => 0,
            'deleted_by' => 0,
            'created_at' => now()
        ]);
        if($createResults){
            return response()->json([
                'status' => true,
                'message' => 'Result has been inserted.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
    public function updateResult($data){
        $user = auth()->user();
        $checklist = Checklist::where('id', $data['checklist_id'])->get()->first();

        $updateResults = Results::where('id',$data['id'])->update([
            'checklist_id' => $data['checklist_id'],
            'category_id' => $checklist->category_id,
            'name' => $data['name'],
            'symbols' => $data['symbols'],
            'percentage' => $data['percentage'],
            'color' => $data['color'],
            'status' => $data['status'],
            'updated_by' => $user->id,
            'updated_at' => now()
        ]);
        if($updateResults){
            return response()->json([
                'status' => true,
                'message' => 'Results has been updated.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
    public function deleteResult($data){
        $user = auth()->user();
        $deleteResult = Results::where('id',$data['id'])->update([
            'status' => 3,
            'updated_by' => $user->id,
            'updated_at' => now()
        ]);

        if($deleteResult){
            return response()->json([
                'status' => true,
                'message' => 'Results has been Deleted.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
}