<?php

namespace App\Customs\Services;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use App\Models\User;

use App\Models\Schedule;
use App\Models\AuditReport;
use App\Models\AuditQuestionReport;

class ReportsService
{
    public function updateReports($data){
        $user = auth()->user();

        $updateReports = AuditReport::where('audit_id',$data['audit_id'])->update([
            'status' => $data['status'],
            'updated_by' => $user->id,
            'updated_at' => now()
        ]);
        $audits = AuditReport::where('audit_id',$data['audit_id'])->get()->first();
		if($data['status'] == 2){
			$action_message = 2;
		}else{
			$action_message = 3;
		}
        $updateSchedule = Schedule::where('id',$audits['schedule_id'])->update([
            'action_status' => $data['status'],
			'action_message' => $action_message,
            'updated_by' => $user->id,
            'updated_at' => now()
        ]);

        if($updateReports){
            return response()->json([
                'status' => true,
                'message' => 'Audit Report has been updated.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
}