<?php

namespace App\Customs\Services;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\ChecklistQuestion;

class QuestionsService
{
    public function createQuestions($data){
        $user = auth()->user();
        // $digits = 3;
        // $questionsNo = rand(pow(10, $digits-1), pow(10, $digits)-1);
        $questionslast_id = ChecklistQuestion::get()->last();
        $questionsNo = $questionslast_id->id + 1;
        // return response()->json($questionsNo);
        $questions_id = 'CQ-'.$questionsNo;

        $option_array = json_decode($data['option_array']);
        
        $createQuestions = ChecklistQuestion::create([
            'questions_id' => $questions_id,
            'title' => $data['title'],
            'type' => $data['type'],
            'option_array' => $option_array,
            'answer' => null,
            'section_id' => $data['section_id'],
            'checklist_id' => $data['checklist_id'],
            'status' => $data['status'],
            'created_by' => $user->id,
            'created_at' => now(),
            'updated_by' => 0,
            'deleted_by' => 0
        ]);
        $ChecklistQuestion = ChecklistQuestion::where('checklist_id', $data['checklist_id'])->where('questions_id',$questions_id)->update(['option_array->answer'=> false]);
        
        if($createQuestions){
            return response()->json([
                'status' => true,
                'message' => 'Checklist Question has been inserted.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
    public function updateQuestions($data){
        $user = auth()->user();
        
        // $option_array = json_decode($data['option_array']);
        $updateQuestions = ChecklistQuestion::where('id',$data['id'])->update([
            'status' => $data['status'],
            'updated_by' => $user->id,
            'updated_at' => now()
        ]);
        
        if($updateQuestions){
            return response()->json([
                'status' => true,
                'message' => 'Checklist Question has been updated.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
    
    public function editQuestions($data){
        $user = auth()->user();
        
        $option_array = json_decode($data['option_array']);
        // return response()->json($data['type']);
        $editQuestions = ChecklistQuestion::where('id',$data['id'])->update([
            'title' => $data['title'],
            'type' => $data['type'],
            'option_array' => $data['option_array'],
            'status' => $data['status'],
            'updated_by' => $user->id,
            'updated_at' => now()
        ]);
        $arrayQuestions = ChecklistQuestion::where('id', $data['id'])->update(['option_array->type'=> $data['type']]);
        $arrayQuestionone = ChecklistQuestion::where('id', $data['id'])->update(['option_array->name'=> $data['type'].'-'.time()]);
        // return print_r($editQuestions);
        
        if($editQuestions){
            return response()->json([
                'status' => true,
                'message' => 'Checklist Question has been updated.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }

    public function deleteQuestions($data){
        $user = auth()->user();
        
        $option_array = json_decode($data['option_array']);
        $updateQuestions = ChecklistQuestion::where('id',$data['id'])->update([
            'status' => 3,
            'updated_by' => $user->id,
            'updated_at' => now()
        ]);
        
        if($updateQuestions){
            return response()->json([
                'status' => true,
                'message' => 'Checklist Question has been updated.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
}