<?php

namespace App\Customs\Services;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Plans;

class PlansService
{
    public function updatePlans($data){
        $user = auth()->user();
        $updatePlans = Plans::where('id',$data['id'])->update([
            'title' => $data['title'],
            'subtitle' => $data['subtitle'],
            'amount' => $data['amount'],
            'days' => $data['days'],
            'feature' => $data['feature'],
            'status' => $data['status'],
            'updated_by' => $user->id,
            'updated_at' => now()
        ]);
        
        if($updatePlans){
            return response()->json([
                'status' => true,
                'message' => 'Plans has been updated.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
}