<?php

namespace App\Customs\Services;
use Illuminate\Support\Facades\Hash;

class PasswordService
{
    private function validateCurrentPassword($current_password){
        if(!password_verify($current_password, auth()->user()->password)){
            response()->json([
                'status' => false,
                'message' => "Your password doesn't match the existing password."
            ])->send();
            exit;
        }
    }
    public function changePassword($data){
        $this->validateCurrentPassword($data['current_password']);
        $updatePassword = auth()->user()->update([
            'password' => Hash::make($data['password'])
        ]);
        if($updatePassword){
            return response()->json([
                'status' => true,
                'message' => 'Your password updated successfully.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
}