<?php

namespace App\Customs\Services;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Locations;

class LocationsService
{
    public function createLocations($data){
        $user = auth()->user();
        $digits = 3;
        $locationsNo = rand(pow(10, $digits-1), pow(10, $digits)-1);;
        $locations_id = 'L'.$locationsNo;

        $createLocations = Locations::create([
            'location_id' => $locations_id,
            'company_id' => $data['company_id'],
            'name' => $data['name'],
            'time_zone' => $data['time_zone'],
            'address' => $data['address'],
            'postcode' => $data['postcode'],
            'status' => $data['status'],
            'created_by' => $user->id,
            'created_at' => now(),
            'updated_by' => 0,
            'deleted_by' => 0
        ]);
        if($createLocations){
            return response()->json([
                'status' => true,
                'message' => 'Locations has been inserted.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
    public function updateLocations($data){
        $user = auth()->user();
        $updateLocations = Locations::where('id',$data['id'])->update([
            'company_id' => $data['company_id'],
            'name' => $data['name'],
            'time_zone' => $data['time_zone'],
            'address' => $data['address'],
            'postcode' => $data['postcode'],
            'status' => $data['status'],
            'updated_by' => $user->id,
            'updated_at' => now()
        ]);
        
        if($updateLocations){
            return response()->json([
                'status' => true,
                'message' => 'Location has been updated.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
}