<?php

namespace App\Customs\Services;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Feedback;

class FeedbackService
{
    public function createFeedback($data){
        $user = auth()->user();
        $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $pin = rand(10, 50)
        . rand(10, 50)
        . $characters[rand(0, strlen($characters) - 1)];
        $string = str_shuffle($pin);
        $feedback_id = 'TK-'.$string;

        $createFeedback = Feedback::create([
            'ticket_id' => $feedback_id,
            'user_id' => $user->id,
            'category' => $data['category'],
            'client_message' => $data['client_message'],
            'status' => 1,
            'created_by' => $user->id,
            'created_at' => now()
        ]);
        if($createFeedback){
            return response()->json([
                'status' => true,
                'message' => 'Your feedback has been submitted.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
    public function updateFeedback($data){
        $user = auth()->user();
        $updateFeedback = Feedback::where('id',$data['id'])->update([
            'admin_message' => $data['admin_message'],
            'status' => $data['status'],
            'updated_by' => $user->id,
            'updated_at' => now()
        ]);
        if($updateFeedback){
            return response()->json([
                'status' => true,
                'message' => 'Feedback has been updated.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
}