<?php

namespace App\Customs\Services;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Category;
use App\Models\CompanyDepartment;

class DepartmentService
{
    public function createDepartment($data){
        $user = auth()->user();

        $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $pin = rand(10, 50)
        . rand(10, 50)
        . $characters[rand(0, strlen($characters) - 1)];
        $string = str_shuffle($pin);
        $user_id = 'CI-'.$string;

        // return response()->json($data['logos_image']);

        // if($data['logos_image'] != null){
        //     $logos = $user_id.'_logo_'.now()->timestamp.'.'.$data['logos_image']->getClientOriginalExtension();
        //     $data['logos_image']->storeAs('profile/',$logos);
        //     $logos_image = $logos;
        // }else{
        //     $logos_image = '';
        // }

        

        $createDepartment = CompanyDepartment::create([
            'user_id' => $user_id,
            'logos' => null,
            'name' => $data['name'],
            'short_name' => 'leansaudit',
            'password' => Hash::make($data['password']),
            'role' => $data['role'],
            'permission' => $data['permission'],
            'total_auditor_active' => $data['total_auditor_active'],
            'total_auditor_inactive' => $data['total_auditor_inactive'],
            'schedules_start_time' => $data['schedules_start_time'],
            'schedules_end_time' => $data['schedules_end_time'],
            'plan_status' => 1,
            'created_by' => $user->id,
            'created_at' => now()
        ]);

        $sectionid = CompanyDepartment::orderBy('id', 'desc')->get()->first();
        $updateUser = User::where('id',$user->id)->update([
            'company_id' => $sectionid['id']
        ]);

        if($createDepartment){
            return response()->json([
                'status' => true,
                'message' => 'Department has been inserted.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
    public function updateDepartment($data){
        $user = auth()->user();
        $updateDepartment = CompanyDepartment::where('id',$data['id'])->update([
            'name' => $data['name'],
            'schedules_start_time' => $data['schedules_start_time'],
            'schedules_end_time' => $data['schedules_end_time'],
            'plan_status' => $data['plan_status'],
            'updated_by' => $user->id,
            'updated_at' => now()
        ]);
        
        if($updateDepartment){
            return response()->json([
                'status' => true,
                'message' => 'Department has been updated.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
}