<?php

namespace App\Customs\Services;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Checklist;

class ChecklistService
{
    public function createChecklist($data){
        $user = auth()->user();
        $digits = 3;
        $checklistNo = rand(pow(10, $digits-1), pow(10, $digits)-1);;
        $checklist_id = 'CH-'.$checklistNo;

        $createChecklist = Checklist::create([
            'checklist_id' => $checklist_id,
            'name' => $data['name'],
            'category_id' => $data['category_id'],
            'status' => $data['status'],
            'company_id' => $user->id,
            'created_by' => $user->id,
            'updated_by' => 0,
            'deleted_by' => 0,
            'created_at' => now(),
            'updated_at' => now()
        ]);
        if($createChecklist){
            return response()->json([
                'status' => true,
                'message' => 'Checklist has been inserted.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
    
    public function updateChecklist($data){
        $user = auth()->user();
        $updateChecklist = Checklist::where('id',$data['id'])->update([
            'name' => $data['name'],
            'category_id' => $data['category_id'],
            'status' => $data['status'],
            'updated_by' => $user->id,
            'updated_at' => now()
        ]);
        if($updateChecklist){
            return response()->json([
                'status' => true,
                'message' => 'Checklist has been updated.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
}