<?php

namespace App\Customs\Services;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Category;

class CategoryService
{
    public function createCategory($data){
        $user = auth()->user();
        $digits = 3;
        $categoryNo = rand(pow(10, $digits-1), pow(10, $digits)-1);
        $category_id = 'CA-'.$categoryNo;

        $createCategory = Category::create([
            'name' => $data['name'],
            'category_id' => $category_id,
            'status' => $data['status'],
            'created_by' => $user->id,
            'created_at' => now()
        ]);
        if($createCategory){
            return response()->json([
                'status' => true,
                'message' => 'Category has been inserted.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
    public function updateCategory($data){
        $user = auth()->user();
        $updateCategory = Category::where('id',$data['id'])->update([
            'name' => $data['name'],
            'status' => $data['status'],
            'updated_by' => $user->id,
            'updated_at' => now(),
            'deleted_by' => $user->id,
            'deleted_at' => now()
        ]);
        
        if($updateCategory){
            return response()->json([
                'status' => true,
                'message' => 'Category has been updated.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
}