<?php

namespace App\Customs\Services;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\Schedule;
use App\Models\Locations;
use App\Models\Category;
use App\Models\Checklist;
use App\Models\ChecklistSection;
use App\Models\ChecklistQuestion;

use App\Models\AuditReport;
use App\Models\AuditQuestionReport;

class AuditsService
{
    public function updateAudits($data){
        $user = auth()->user();

        $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $pin = rand(10, 50)
        . rand(10, 50)
        . $characters[rand(0, strlen($characters) - 1)];
        $string = str_shuffle($pin);
        $audit_id = 'AA-'.$string;

        $schedule = Schedule::where('id', $data['schedule_id'])->get()->first();
        $questiondata = ChecklistQuestion::where('questions_id', $data['questions_id'])->get()->first();
        if(empty($schedule) || empty($questiondata)){
            return response()->json([
                'status' => false,
                'message' => 'The Schedule ID or Question you entered does not exist in the system.'
            ],401);
        }
        $location = Locations::where('id', $schedule['location_id'])->get()->first();
        $checklist = Checklist::where('id', $schedule['checklist_id'])->get()->first();
        $category = Category::where('id', $schedule['category_id'])->get()->first();
        $checklistsections = ChecklistSection::where('id', $questiondata['section_id'])->get()->first();
        
        $auditreports = AuditReport::where('schedule_id', $data['schedule_id'])->get()->count();
        $auditquestionreport = AuditQuestionReport::where('schedule_id', $data['schedule_id'])->where('checklist_id', $schedule['checklist_id'])->get()->count();
        $questiontotal = ChecklistQuestion::where('checklist_id', $schedule['checklist_id'])->get()->count();

        $qestion_answer_update = AuditQuestionReport::where('questions_id',$questiondata['id'])->where('schedule_id', $data['schedule_id'])->where('checklist_id', $schedule['checklist_id'])->get()->first();
        
        if(!empty($qestion_answer_update)){
            if(!empty($data['questions_image'])){
                $incim=0;
                foreach ($data['questions_image'] as $image) {
                    $incim+=1;
                    $questions = $schedule['schedule_id'].'_question_'.$incim.''.now()->timestamp.'.'.$image->getClientOriginalExtension();
                    $image->storeAs('question/'.$schedule['schedule_id'],$questions);
                    $questions_image[] = $questions;    
                }
            }else{
                $questions_image = $qestion_answer_update['questions_image'];
            }
            $updateAuditsQuesanswer = AuditQuestionReport::where('id',$qestion_answer_update['id'])->update([
                'questions_answer' => $data['questions_answer'],
                'questions_answer_array' => $questiondata['option_array'],
                'questions_image' => $questions_image,
                'questions_comment' => $data['questions_comment'],
                'questions_points' => $data['points'],
                'questions_status' => 0,
                'status' => 1,
                'updated_by' => $user->id,
                'updated_at' => now(),
            ]);
            
            if($questiondata['type'] == 'checkbox-group'){
                $questiont = AuditQuestionReport::where('schedule_id', $data['schedule_id'])->where('checklist_id', $schedule['checklist_id'])->where('questions_id', $questiondata['id'])->get()->first();
                $explode_answer = explode(', ', $data['questions_answer']);
                for($ia = 0; $ia < count($explode_answer); $ia++){
                    if ($questiont) {
                        $optionArray = $questiont->questions_answer_array;
                        if (isset($optionArray['values'])) {
                            foreach ($optionArray['values'] as &$value) {
                                if (isset($value['label']) && $value['label'] === $explode_answer[$ia]) {
                                    $value['selected'] = true;
                                    break;
                                }
                            }
                        }
                        $questiont->questions_answer_array = $optionArray;
                        $questiont->save();
                    }
                }
                $AuditQuestionReport = AuditQuestionReport::where('schedule_id', $data['schedule_id'])->where('checklist_id', $schedule['checklist_id'])->where('questions_id', $questiondata['id'])->update(['questions_answer_array->answer'=> true]);
            }else{
                $questiont = AuditQuestionReport::where('schedule_id', $data['schedule_id'])->where('checklist_id', $schedule['checklist_id'])->where('questions_id', $questiondata['id'])->get()->first();
                if ($questiont) {
                    $optionArray = $questiont->questions_answer_array;
                    if (isset($optionArray['values'])) {
                        foreach ($optionArray['values'] as &$value) {
                            if (isset($value['label']) && $value['label'] === $data['questions_answer']) {
                                $value['selected'] = true;
                                break;
                            }
                        }
                    }
                    $questiont->questions_answer_array = $optionArray;
                    $questiont->save();
                }
                $AuditQuestionReport = AuditQuestionReport::where('schedule_id', $data['schedule_id'])->where('checklist_id', $schedule['checklist_id'])->where('questions_id', $questiondata['id'])->update(['questions_answer_array->answer'=> true]);
            }

            if($updateAuditsQuesanswer){
                return response()->json([
                    'status' => true,
                    'message' => 'Audits Question has been updated.'
                ],200);
            }else{
                return response()->json([
                    'status' => false,
                    'message' => 'Something went wrong.'
                ],401);
            }
        }else{
            if($auditreports == 0){
                if(!empty($data['signature_image'])){
                    $signature = $schedule['schedule_id'].'_sign_'.now()->timestamp.'.'.$data['signature_image']->getClientOriginalExtension();
                    $data['signature_image']->storeAs('signature/'.$schedule['schedule_id'],$signature);
                    $signature_image = $signature;
                }else{
                    $signature_image = '';
                }
        
                if(!empty($data['questions_image'])){
                    $incim=0;
                    foreach ($data['questions_image'] as $image) {
                        $incim+=1;
                        $questions = $schedule['schedule_id'].'_question_'.$incim.''.now()->timestamp.'.'.$image->getClientOriginalExtension();
                        $image->storeAs('question/'.$schedule['schedule_id'],$questions);
                        $questions_image[] = $questions;    
                    }
                }else{
                    $questions_image = null;
                }
    
                $updateAudits = AuditReport::create([
                    'audit_id' => $audit_id,
                    'user_id' => $user->id,
                    'schedule_id' => $data['schedule_id'],
                    'checklist_id' => $schedule['checklist_id'],
                    'checklist_name' => $checklist['name'],
                    'location_id' => $schedule['location_id'],
                    'location_name' => $location['name'],
                    'audit_date' => now(),
                    'signature_image' => null,
                    'status' => 0,
                    'created_by' => $user->id,
                    'created_at' => now(),
                ]);
                $updateAuditsQues = AuditQuestionReport::create([
                    'audit_id' => $audit_id,
                    'user_id' => $user->id,
                    'schedule_id' => $data['schedule_id'],
                    'checklist_id' => $schedule['checklist_id'],
                    'checklist_name' => $checklist['name'],
                    'category_id' => $schedule['category_id'],
                    'category_name' => $category['name'],
                    'section_id' => $checklistsections['id'],
                    'section_name' => $checklistsections['name'],
                    'questions_id' => $questiondata['id'],
                    'questions_name' => $questiondata['title'],
                    'questions_answer' => $data['questions_answer'],
                    'questions_answer_array' => $questiondata['option_array'],
                    'questions_image' => $questions_image,
                    'questions_comment' => $data['questions_comment'],
                    'questions_points' => $data['points'],
                    'questions_status' => 0,
                    'status' => 1,
                    'created_by' => $user->id,
                    'created_at' => now(),
                ]);
                
                if($questiondata['type'] == 'checkbox-group'){
                    $questiont = AuditQuestionReport::where('schedule_id', $data['schedule_id'])->where('checklist_id', $schedule['checklist_id'])->where('questions_id', $questiondata['id'])->get()->first();
                    $explode_answer = explode(', ', $data['questions_answer']);
                    for($ia = 0; $ia < count($explode_answer); $ia++){
                        if ($questiont) {
                            $optionArray = $questiont->questions_answer_array;
                            if (isset($optionArray['values'])) {
                                foreach ($optionArray['values'] as &$value) {
                                    if (isset($value['label']) && $value['label'] === $explode_answer[$ia]) {
                                        $value['selected'] = true;
                                        break;
                                    }
                                }
                            }
                            $questiont->questions_answer_array = $optionArray;
                            $questiont->save();
                        }
                    }
                    $AuditQuestionReport = AuditQuestionReport::where('schedule_id', $data['schedule_id'])->where('checklist_id', $schedule['checklist_id'])->where('questions_id', $questiondata['id'])->update(['questions_answer_array->answer'=> true]);
                }else{
                    $questiont = AuditQuestionReport::where('schedule_id', $data['schedule_id'])->where('checklist_id', $schedule['checklist_id'])->where('questions_id', $questiondata['id'])->get()->first();
                    if ($questiont) {
                        $optionArray = $questiont->questions_answer_array;
                        if (isset($optionArray['values'])) {
                            foreach ($optionArray['values'] as &$value) {
                                if (isset($value['label']) && $value['label'] === $data['questions_answer']) {
                                    $value['selected'] = true;
                                    break;
                                }
                            }
                        }
                        $questiont->questions_answer_array = $optionArray;
                        $questiont->save();
                    }
                    $AuditQuestionReport = AuditQuestionReport::where('schedule_id', $data['schedule_id'])->where('checklist_id', $schedule['checklist_id'])->where('questions_id', $questiondata['id'])->update(['questions_answer_array->answer'=> true]);
                }
                

                $total_ques_answered = AuditQuestionReport::where('schedule_id', $data['schedule_id'])->where('checklist_id', $schedule['checklist_id'])->get()->count();
                $updateSchedule = Schedule::where('id', $data['schedule_id'])->update([
                    'status' => 2,
                    'total_ques_answered' => $total_ques_answered,
                    'updated_by' => $user->id,
                    'updated_at' => now(),
                ]);
            }else{
                $total_ques_answered = AuditQuestionReport::where('schedule_id', $data['schedule_id'])->where('checklist_id', $schedule['checklist_id'])->get()->count();
                $updateSchedule = Schedule::where('id', $data['schedule_id'])->update([
                    'status' => 2,
                    'total_ques_answered' => $total_ques_answered,
                    'updated_by' => $user->id,
                    'updated_at' => now(),
                ]);
                if($auditquestionreport != $questiontotal){
                    if(!empty($data['signature_image'])){
                        $signature = $schedule['schedule_id'].'_sign_'.now()->timestamp.'.'.$data['signature_image']->getClientOriginalExtension();
                        $data['signature_image']->storeAs('signature/'.$schedule['schedule_id'],$signature);
                        $signature_image = $signature;
                    }else{
                        $signature_image = '';
                    }
            
                    if(!empty($data['questions_image'])){
                        $incim=0;
                        foreach ($data['questions_image'] as $image) {
                            $incim+=1;
                            $questions = $schedule['schedule_id'].'_question_'.$incim.''.now()->timestamp.'.'.$image->getClientOriginalExtension();
                            $image->storeAs('question/'.$schedule['schedule_id'],$questions);
                            $questions_image[] = $questions;    
                        }
                    }else{
                        $questions_image = null;
                    }
                    
                    $auditreports = AuditReport::where('schedule_id', $data['schedule_id'])->get()->first();
                    $updateAuditsQues = AuditQuestionReport::create([
                        'audit_id' => $auditreports['audit_id'],
                        'user_id' => $user->id,
                        'schedule_id' => $data['schedule_id'],
                        'checklist_id' => $schedule['checklist_id'],
                        'checklist_name' => $checklist['name'],
                        'category_id' => $schedule['category_id'],
                        'category_name' => $category['name'],
                        'section_id' => $checklistsections['id'],
                        'section_name' => $checklistsections['name'],
                        'questions_id' => $questiondata['id'],
                        'questions_name' => $questiondata['title'],
                        'questions_answer' => $data['questions_answer'],
                        'questions_answer_array' => $questiondata['option_array'],
                        'questions_image' => $questions_image,
                        'questions_comment' => $data['questions_comment'],
                        'questions_points' => $data['points'],
                        'questions_status' => 0,
                        'status' => 1,
                        'created_by' => $user->id,
                        'created_at' => now(),
                    ]);
                    
                    if($questiondata['type'] == 'checkbox-group'){
                        $questiont = AuditQuestionReport::where('schedule_id', $data['schedule_id'])->where('checklist_id', $schedule['checklist_id'])->where('questions_id', $questiondata['id'])->get()->first();
                        $explode_answer = explode(', ', $data['questions_answer']);
                        for($ia = 0; $ia < count($explode_answer); $ia++){
                            if ($questiont) {
                                $optionArray = $questiont->questions_answer_array;
                                if (isset($optionArray['values'])) {
                                    foreach ($optionArray['values'] as &$value) {
                                        if (isset($value['label']) && $value['label'] === $explode_answer[$ia]) {
                                            $value['selected'] = true;
                                            break;
                                        }
                                    }
                                }
                                $questiont->questions_answer_array = $optionArray;
                                $questiont->save();
                            }
                        }
                        $AuditQuestionReport = AuditQuestionReport::where('schedule_id', $data['schedule_id'])->where('checklist_id', $schedule['checklist_id'])->where('questions_id', $questiondata['id'])->update(['questions_answer_array->answer'=> true]);
                    }else{
                        $questiont = AuditQuestionReport::where('schedule_id', $data['schedule_id'])->where('checklist_id', $schedule['checklist_id'])->where('questions_id', $questiondata['id'])->get()->first();
                        if ($questiont) {
                            $optionArray = $questiont->questions_answer_array;
                            if (isset($optionArray['values'])) {
                                foreach ($optionArray['values'] as &$value) {
                                    if (isset($value['label']) && $value['label'] === $data['questions_answer']) {
                                        $value['selected'] = true;
                                        break;
                                    }
                                }
                            }
                            $questiont->questions_answer_array = $optionArray;
                            $questiont->save();
                        }
                        $AuditQuestionReport = AuditQuestionReport::where('schedule_id', $data['schedule_id'])->where('checklist_id', $schedule['checklist_id'])->where('questions_id', $questiondata['id'])->update(['questions_answer_array->answer'=> true]);
                    }
                    
                }
            }
            if($schedule){
                return response()->json([
                    'status' => true,
                    'message' => 'Audits has been updated.'
                ],200);
            }else{
                return response()->json([
                    'status' => false,
                    'message' => 'Something went wrong.'
                ],401);
            }
        }
    }

    public function updateSignature($data){
        $user = auth()->user();
        $schedule = Schedule::where('id', $data['schedule_id'])->get()->first();

        if(!empty($data['signature_image'])){
            $signature = $schedule['schedule_id'].'_sign_'.now()->timestamp.'.'.$data['signature_image']->getClientOriginalExtension();
            $data['signature_image']->storeAs('signature/'.$schedule['schedule_id'],$signature);
            $signature_image = $signature;
        }else{
            $signature_image = '';
        }
        $updateAudits = AuditReport::where('schedule_id', $data['schedule_id'])->update([
            'signature_image' => $signature_image,
            'status' => 1,
            'updated_by' => $user->id,
            'updated_at' => now(),
        ]);
        $updateAuditQuestionReport = AuditQuestionReport::where('schedule_id', $data['schedule_id'])->update([
            'questions_status' => 1,
            'updated_by' => $user->id,
            'updated_at' => now(),
        ]);
        $updateSchedule = Schedule::where('id', $data['schedule_id'])->update([
            'status' => 4,
            'action_status' => 1,
            'action_message' => 1,
            'updated_by' => $user->id,
            'updated_at' => now(),
        ]);

        if($schedule){
            return response()->json([
                'status' => true,
                'message' => 'Your Signature report is submitted.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
}