<?php

namespace App\Customs\Services;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use App\Models\User;

use Mail;

class AuditorsService
{
    public function createAuditors($data){
        $user = auth()->user();
        $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $pin = rand(10, 50)
        . rand(10, 50)
        . $characters[rand(0, strlen($characters) - 1)];
        $string = str_shuffle($pin);

        $user_id = 'AU-'.$string;

        $createAuditors = User::create([
            'user_id' => $user_id,
            'first_name' => $data['first_name'],
            'last_name' => $data['last_name'],
            'email' => $data['email'],
            'password' => Hash::make($data['password']),
            'role' => 3,
            'permission' => 3,
            'mobile_no' => null,
            'gender' => null,
            'plan_day_remain' => $user->plan_day_remain,
            'plan_actived' => $user->plan_actived,
            'access_app' => 1,
            'access_web' => 0,
            'status' => $data['status'],
            'created_by' => $data['created_by'],
            'company_id' => $data['company_id'],
            'job_title' => $data['job_title'],
            'time_zone' => $data['time_zone']
        ]);
        
        $base_url = env('APP_URL');
        $maildata['url'] = $base_url;
        $maildata['email'] = $data['email'];
        $maildata['title'] = 'Welcome to Lensaudit';
        $maildata['username'] = $data['first_name'].' '.$data['last_name'];
        $maildata['password'] = $data['password'];
        $maildata['body'] = 'Thanks for joining Lensaudit360, your app account is ready and you can start your audit now.';

        Mail::send('welcomeauditor',['maildata'=>$maildata],function($message) use ($maildata){
            $message->to($maildata['email'])->subject($maildata['title']);
        });
        
        if($createAuditors){
            return response()->json([
                'status' => true,
                'message' => 'Auditor has been inserted.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
    public function updateAuditors($data){
        $user = auth()->user();

        $updateAuditors = User::where('id',$data['id'])->update([
            'first_name' => $data['first_name'],
            'last_name' => $data['last_name'],
            'email' => $data['email'],
         //   'password' => $data['password'],
            'role' => 3,
            'permission' => 3,
            'mobile_no' => null,
            'gender' => null,
            'plan_day_remain' => $user->plan_day_remain,
            'plan_actived' => $user->plan_actived,
            'access_app' => 1,
            'access_web' => 0,
            'status' => $data['status'],
            // 'updated_by' => $data['updated_by'],
            'company_id' => $data['company_id'],
            'job_title' => $data['job_title'],
            'time_zone' => $data['time_zone']
        ]);
        
        if($updateAuditors){
            return response()->json([
                'status' => true,
                'message' => 'Auditor has been updated.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
}