<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
      'App\Console\Commands\CheckUserExpire',
      'App\Console\Commands\SendEmailsExpire',
      'App\Console\Commands\ScheduleOverdue',
    ];
    
    /**
     * Define the application's command schedule.
     */
    protected function schedule(Schedule $schedule): void
    {
        // $schedule->command('inspire')->hourly();
        $schedule->command(\App\Console\Commands\CheckUserExpire::class)->dailyAt('00:00');
        $schedule->command(\App\Console\Commands\SendEmailsExpire::class)->dailyAt('02:00');
        // $schedule->command(\App\Console\Commands\ScheduleOverdue::class)->everyMinute()->withoutOverlapping();
    }

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
