<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;

class ScheduleOverdue extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:schedule_overdue';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';
    
    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $now_time = now()->format('H:i:s');
        $now_date = now()->format('Y-m-d');
        $schedule = Schedule::where('status', '!=', 4)->get();
        $schedulelist = [];
        for($ab = 0; $ab < count($schedule); $ab++){
            if($schedule[$ab]['reschedule_status'] == 1){
                $schedule_t = Schedule::where('id', $schedule[$ab]['id'])->where('status', '!=', 3)->where('reschedule_on', '>=',$now_date)->where('re_end_time', '<=',$now_time)->get()->first();
            }else{
                $schedule_t = Schedule::where('id', $schedule[$ab]['id'])->where('status', '!=', 3)->where('schedule_on', '>=',$now_date)->where('end_time', '<=',$now_time)->get()->first();
            }
            if(!empty($schedule_t)){
                $schedulelist[] = [
                    'id' => $schedule_t['id'],
                    'schedule_on' => $schedule_t['schedule_on'],
                    'end_time' => $schedule_t['end_time'],
                    'now' => now(),
                    'now_time' => $now_time,
                    'now_date' => $now_date,
                ];
                $overdue = Schedule::where('id',$schedule_t['id'])->update([
                    'status' => 3
                ]);
            }
        }
    }
}
