<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use App\Models\Invoice;

use Illuminate\Support\Facades\DB;
class CheckUserExpire extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:check-user-expire';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
     public function handle()
    {
        $user_count = User::where('role', 2)->get();
        $userlist = [];
        for($ab = 0; $ab < count($user_count); $ab++){
            $invoice = Invoice::where('created_by', $user_count[$ab]['id'])->orderBy('created_at','DESC')->get()->first();

            $day_remain = now()->diffInDays($invoice['billing_end_date']);
            if($invoice['billing_end_date'] >= now()){
                $userlist[] = [
                    'days_remain' => $day_remain,
                    'userid' => $user_count[$ab]['id'],
                    'current_date' => now(),
                    'expire_date' => $invoice['billing_end_date'],
                ];
                $expire = User::where('id',$user_count[$ab]['id'])->update([
                    'plan_day_remain' => $day_remain
                ]);
                $expire_auditor = User::where('created_by',$invoice['created_by'])->update([
                    'plan_day_remain' => $day_remain
                ]);
            }
            if($invoice['billing_end_date'] < now()){
                $userlist[] = [
                    'days_remain' => $day_remain,
                    'userid' => $user_count[$ab]['id'],
                    'current_date' => now(),
                    'expire_date' => $invoice['billing_end_date'],
                ];
                $Expire = User::where('id',$invoice['created_by'])->update([
                    'plan_day_remain' => 0
                ]);
                $Expire = User::where('created_by',$invoice['created_by'])->update([
                    'plan_day_remain' => 0
                ]);
            }
        }
    }
}